﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CRSe.CRS.BO
{
    [Serializable, DataContract]
    //[System.Xml.Serialization.XmlTypeAttribute(AnonymousType = true, Namespace = "http://schemas.microsoft.com/sqlserver/reporting/2010/01/shareddatasetdefinition")]
    [System.Xml.Serialization.XmlRootAttribute(ElementName = "SharedDataSet", Namespace = "http://schemas.microsoft.com/sqlserver/reporting/2010/01/shareddatasetdefinition", IsNullable = false)]
    public partial class SharedDataSet
    {
        private const string COMMANDTEXT = "SELECT [CRS].[STD_REGISTRY].[CODE] AS [STD_REGISTRY_CODE] ,[CRS].[STD_REGISTRY].[COMMENTS] AS [STD_REGISTRY_COMMENTS] ,[CRS].[STD_REGISTRY].[CREATED] AS [STD_REGISTRY_CREATED] ,[CRS].[STD_REGISTRY].[CREATEDBY] AS [STD_REGISTRY_CREATEDBY] ,[CRS].[STD_REGISTRY].[DESCRIPTION_TEXT] AS [STD_REGISTRY_DESCRIPTION_TEXT] ,[CRS].[STD_REGISTRY].[ID] AS [STD_REGISTRY_ID] ,[CRS].[STD_REGISTRY].[INACTIVE_DATE] AS [STD_REGISTRY_INACTIVE_DATE] ,[CRS].[STD_REGISTRY].[INACTIVE_FLAG] AS [STD_REGISTRY_INACTIVE_FLAG] ,[CRS].[STD_REGISTRY].[NAME] AS [STD_REGISTRY_NAME] ,[CRS].[STD_REGISTRY].[REGISTRY_ADMINISTRATOR] AS [STD_REGISTRY_REGISTRY_ADMINISTRATOR] ,[CRS].[STD_REGISTRY].[REGISTRY_OWNER] AS [STD_REGISTRY_REGISTRY_OWNER] ,[CRS].[STD_REGISTRY].[REGISTRY_SUPPORT_CONTACT] AS [STD_REGISTRY_REGISTRY_SUPPORT_CONTACT] ,[CRS].[STD_REGISTRY].[SORT_ORDER] AS [STD_REGISTRY_SORT_ORDER] ,[CRS].[STD_REGISTRY].[UPDATED] AS [STD_REGISTRY_UPDATED] ,[CRS].[STD_REGISTRY].[UPDATEDBY] AS [STD_REGISTRY_UPDATEDBY] ,[CRS].[REFERRAL].[COMMENT_TEXT] AS [REFERRAL_COMMENT_TEXT] ,[CRS].[REFERRAL].[CREATED] AS [REFERRAL_CREATED] ,[CRS].[REFERRAL].[CREATEDBY] AS [REFERRAL_CREATEDBY] ,[CRS].[REFERRAL].[CREATEDSOURCE] AS [REFERRAL_CREATEDSOURCE] ,[CRS].[REFERRAL].[DUPLICATE_FLAG] AS [REFERRAL_DUPLICATE_FLAG] ,[CRS].[REFERRAL].[PATIENT_ID] AS [REFERRAL_PATIENT_ID] ,[CRS].[REFERRAL].[PROVIDER_ID] AS [REFERRAL_PROVIDER_ID] ,[CRS].[REFERRAL].[REFERRAL_CLASS_TEXT] AS [REFERRAL_REFERRAL_CLASS_TEXT] ,[CRS].[REFERRAL].[REFERRAL_DATE] AS [REFERRAL_REFERRAL_DATE] ,[CRS].[REFERRAL].[REFERRAL_ID] AS [REFERRAL_REFERRAL_ID] ,[CRS].[REFERRAL].[REVIEW_BY] AS [REFERRAL_REVIEW_BY] ,[CRS].[REFERRAL].[REVIEW_DATE] AS [REFERRAL_REVIEW_DATE] ,[CRS].[REFERRAL].[STD_REFERRALSTS_ID] AS [REFERRAL_STD_REFERRALSTS_ID] ,[CRS].[REFERRAL].[STD_REGISTRY_ID] AS [REFERRAL_STD_REGISTRY_ID] ,[CRS].[REFERRAL].[STD_REMINDERCLASS_ID] AS [REFERRAL_STD_REMINDERCLASS_ID] ,[CRS].[REFERRAL].[UPDATED] AS [REFERRAL_UPDATED] ,[CRS].[REFERRAL].[UPDATEDBY] AS [REFERRAL_UPDATEDBY] ,[CRS].[REFERRAL].[UPDATEDSOURCE] AS [REFERRAL_UPDATEDSOURCE] ,[CRS].[PATIENT].[BIRTH_DATE] AS [PATIENT_BIRTH_DATE] ,[CRS].[PATIENT].[CELL_PHONE] AS [PATIENT_CELL_PHONE] ,[CRS].[PATIENT].[CREATED] AS [PATIENT_CREATED] ,[CRS].[PATIENT].[CREATEDBY] AS [PATIENT_CREATEDBY] ,[CRS].[PATIENT].[DEATH_DATE] AS [PATIENT_DEATH_DATE] ,[CRS].[PATIENT].[EMAIL_ADDRESS] AS [PATIENT_EMAIL_ADDRESS] ,[CRS].[PATIENT].[FIRST_NAME] AS [PATIENT_FIRST_NAME] ,[CRS].[PATIENT].[LAST_NAME] AS [PATIENT_LAST_NAME] ,[CRS].[PATIENT].[MIDDLE_NAME] AS [PATIENT_MIDDLE_NAME] ,[CRS].[PATIENT].[OEFOIF_IND] AS [PATIENT_OEFOIF_IND] ,[CRS].[PATIENT].[PATIENT_ID] AS [PATIENT_PATIENT_ID] ,[CRS].[PATIENT].[PATIENTSID] AS [PATIENT_PATIENTSID] ,[CRS].[PATIENT].[PERFERRED_ADDRESS_TYPE] AS [PATIENT_PERFERRED_ADDRESS_TYPE] ,[CRS].[PATIENT].[UPDATED] AS [PATIENT_UPDATED] ,[CRS].[PATIENT].[UPDATEDBY] AS [PATIENT_UPDATEDBY] ,[CRS].[SPATIENT].[AddressChangeInstitutionIEN] AS [SPATIENT_AddressChangeInstitutionIEN] ,[CRS].[SPATIENT].[AddressChangeInstitutionSID] AS [SPATIENT_AddressChangeInstitutionSID] ,[CRS].[SPATIENT].[AddressChangeStaffIEN] AS [SPATIENT_AddressChangeStaffIEN] ,[CRS].[SPATIENT].[AddressChangeStaffSID] AS [SPATIENT_AddressChangeStaffSID] ,[CRS].[SPATIENT].[Age] AS [SPATIENT_Age] ,[CRS].[SPATIENT].[BadAddressIndicator] AS [SPATIENT_BadAddressIndicator] ,[CRS].[SPATIENT].[CDDeterminingInstitutionIEN] AS [SPATIENT_CDDeterminingInstitutionIEN] ,[CRS].[SPATIENT].[City] AS [SPATIENT_City] ,[CRS].[SPATIENT].[CombatFromVistaDate] AS [SPATIENT_CombatFromVistaDate] ,[CRS].[SPATIENT].[CombatToVistaDate] AS [SPATIENT_CombatToVistaDate] ,[CRS].[SPATIENT].[ConfidentialAddressActiveFlag] AS [SPATIENT_ConfidentialAddressActiveFlag] ,[CRS].[SPATIENT].[Country] AS [SPATIENT_Country] ,[CRS].[SPATIENT].[CountryIEN] AS [SPATIENT_CountryIEN] ,[CRS].[SPATIENT].[CountrySID] AS [SPATIENT_CountrySID] ,[CRS].[SPATIENT].[County] AS [SPATIENT_County] ,[CRS].[SPATIENT].[Created] AS [SPATIENT_Created] ,[CRS].[SPATIENT].[CreatedBy] AS [SPATIENT_CreatedBy] ,[CRS].[SPATIENT].[CurrentMeansTestStatusIEN] AS [SPATIENT_CurrentMeansTestStatusIEN] ,[CRS].[SPATIENT].[DateOfBirth] AS [SPATIENT_DateOfBirth] ,[CRS].[SPATIENT].[DateOfBirthText] AS [SPATIENT_DateOfBirthText] ,[CRS].[SPATIENT].[DateOfDeath] AS [SPATIENT_DateOfDeath] ,[CRS].[SPATIENT].[DateOfDeathText] AS [SPATIENT_DateOfDeathText] ,[CRS].[SPATIENT].[Deceased] AS [SPATIENT_Deceased] ,[CRS].[SPATIENT].[DEFAULT_RECORD] AS [SPATIENT_DEFAULT_RECORD] ,[CRS].[SPATIENT].[Eligibility] AS [SPATIENT_Eligibility] ,[CRS].[SPATIENT].[EligibilityIEN] AS [SPATIENT_EligibilityIEN] ,[CRS].[SPATIENT].[EligibilitySID] AS [SPATIENT_EligibilitySID] ,[CRS].[SPATIENT].[EligibilityStatus] AS [SPATIENT_EligibilityStatus] ,[CRS].[SPATIENT].[EligibilityVACode] AS [SPATIENT_EligibilityVACode] ,[CRS].[SPATIENT].[EligibilityVerificationSource] AS [SPATIENT_EligibilityVerificationSource] ,[CRS].[SPATIENT].[EmailAddress] AS [SPATIENT_EmailAddress] ,[CRS].[SPATIENT].[EnteredIntoFileDate] AS [SPATIENT_EnteredIntoFileDate] ,[CRS].[SPATIENT].[EnteredIntoFileDateTransformSID] AS [SPATIENT_EnteredIntoFileDateTransformSID] ,[CRS].[SPATIENT].[EnteredIntoFileVistaErrorDate] AS [SPATIENT_EnteredIntoFileVistaErrorDate] ,[CRS].[SPATIENT].[ETLBatchID] AS [SPATIENT_ETLBatchID] ,[CRS].[SPATIENT].[ExcludeFromFacilityDirectoryFlag] AS [SPATIENT_ExcludeFromFacilityDirectoryFlag] ,[CRS].[SPATIENT].[Gender] AS [SPATIENT_Gender] ,[CRS].[SPATIENT].[GISAddressType] AS [SPATIENT_GISAddressType] ,[CRS].[SPATIENT].[GISAddressUpdatedDate] AS [SPATIENT_GISAddressUpdatedDate] ,[CRS].[SPATIENT].[GISCongressDistrict] AS [SPATIENT_GISCongressDistrict] ,[CRS].[SPATIENT].[GISFIPSCode] AS [SPATIENT_GISFIPSCode] ,[CRS].[SPATIENT].[GISLocatorName] AS [SPATIENT_GISLocatorName] ,[CRS].[SPATIENT].[GISMarket] AS [SPATIENT_GISMarket] ,[CRS].[SPATIENT].[GISMatchedAddress] AS [SPATIENT_GISMatchedAddress] ,[CRS].[SPATIENT].[GISMatchMethodCode] AS [SPATIENT_GISMatchMethodCode] ,[CRS].[SPATIENT].[GISMatchScore] AS [SPATIENT_GISMatchScore] ,[CRS].[SPATIENT].[GISMatchStatusCode] AS [SPATIENT_GISMatchStatusCode] ,[CRS].[SPATIENT].[GISPatientAddressLatitude] AS [SPATIENT_GISPatientAddressLatitude] ,[CRS].[SPATIENT].[GISPatientAddressLongitude] AS [SPATIENT_GISPatientAddressLongitude] ,[CRS].[SPATIENT].[GISSector] AS [SPATIENT_GISSector] ,[CRS].[SPATIENT].[GISStreetSide] AS [SPATIENT_GISStreetSide] ,[CRS].[SPATIENT].[GISSubmarket] AS [SPATIENT_GISSubmarket] ,[CRS].[SPATIENT].[GISURH] AS [SPATIENT_GISURH] ,[CRS].[SPATIENT].[InsuranceCoverageFlag] AS [SPATIENT_InsuranceCoverageFlag] ,[CRS].[SPATIENT].[LastServiceEntryDate] AS [SPATIENT_LastServiceEntryDate] ,[CRS].[SPATIENT].[LastServiceEntryDateTransformSID] AS [SPATIENT_LastServiceEntryDateTransformSID] ,[CRS].[SPATIENT].[LastServiceEntryVistaErrorDate] AS [SPATIENT_LastServiceEntryVistaErrorDate] ,[CRS].[SPATIENT].[LastServiceSeparationDate] AS [SPATIENT_LastServiceSeparationDate] ,[CRS].[SPATIENT].[LastServiceSeparationDateTransformSID] AS [SPATIENT_LastServiceSeparationDateTransformSID] ,[CRS].[SPATIENT].[LastServiceSeparationVistaErrorDate] AS [SPATIENT_LastServiceSeparationVistaErrorDate] ,[CRS].[SPATIENT].[MaritalStatus] AS [SPATIENT_MaritalStatus] ,[CRS].[SPATIENT].[MaritalStatusIEN] AS [SPATIENT_MaritalStatusIEN] ,[CRS].[SPATIENT].[MaritalStatusSID] AS [SPATIENT_MaritalStatusSID] ,[CRS].[SPATIENT].[MedicaidNumber] AS [SPATIENT_MedicaidNumber] ,[CRS].[SPATIENT].[MothersMaidenName] AS [SPATIENT_MothersMaidenName] ,[CRS].[SPATIENT].[OEF_OIF_IND] AS [SPATIENT_OEF_OIF_IND] ,[CRS].[SPATIENT].[OpCode] AS [SPATIENT_OpCode] ,[CRS].[SPATIENT].[Patient_ID] AS [SPATIENT_Patient_ID] ,[CRS].[SPATIENT].[PatientFirstName] AS [SPATIENT_PatientFirstName] ,[CRS].[SPATIENT].[PatientICN] AS [SPATIENT_PatientICN] ,[CRS].[SPATIENT].[PatientICNChecksum] AS [SPATIENT_PatientICNChecksum] ,[CRS].[SPATIENT].[PatientIEN] AS [SPATIENT_PatientIEN] ,[CRS].[SPATIENT].[PatientLastName] AS [SPATIENT_PatientLastName] ,[CRS].[SPATIENT].[PatientName] AS [SPATIENT_PatientName] ,[CRS].[SPATIENT].[PatientSID] AS [SPATIENT_PatientSID] ,[CRS].[SPATIENT].[PatientSSN] AS [SPATIENT_PatientSSN] ,[CRS].[SPATIENT].[PercentServiceConnect] AS [SPATIENT_PercentServiceConnect] ,[CRS].[SPATIENT].[PeriodOfService] AS [SPATIENT_PeriodOfService] ,[CRS].[SPATIENT].[PeriodOfServiceIEN] AS [SPATIENT_PeriodOfServiceIEN] ,[CRS].[SPATIENT].[PeriodOfServiceSID] AS [SPATIENT_PeriodOfServiceSID] ,[CRS].[SPATIENT].[PhoneCellular] AS [SPATIENT_PhoneCellular] ,[CRS].[SPATIENT].[PhoneResidence] AS [SPATIENT_PhoneResidence] ,[CRS].[SPATIENT].[PhoneWork] AS [SPATIENT_PhoneWork] ,[CRS].[SPATIENT].[PostalCode] AS [SPATIENT_PostalCode] ,[CRS].[SPATIENT].[POWLocationIEN] AS [SPATIENT_POWLocationIEN] ,[CRS].[SPATIENT].[PreferredInstitutionIEN] AS [SPATIENT_PreferredInstitutionIEN] ,[CRS].[SPATIENT].[Province] AS [SPATIENT_Province] ,[CRS].[SPATIENT].[PseudoSSNFlag] AS [SPATIENT_PseudoSSNFlag] ,[CRS].[SPATIENT].[PurpleHeartInstitutionIEN] AS [SPATIENT_PurpleHeartInstitutionIEN] ,[CRS].[SPATIENT].[RaceIEN] AS [SPATIENT_RaceIEN] ,[CRS].[SPATIENT].[RaceSID] AS [SPATIENT_RaceSID] ,[CRS].[SPATIENT].[Religion] AS [SPATIENT_Religion] ,[CRS].[SPATIENT].[ReligionIEN] AS [SPATIENT_ReligionIEN] ,[CRS].[SPATIENT].[ReligionSID] AS [SPATIENT_ReligionSID] ,[CRS].[SPATIENT].[RoomBedIEN] AS [SPATIENT_RoomBedIEN] ,[CRS].[SPATIENT].[ScrSSN] AS [SPATIENT_ScrSSN] ,[CRS].[SPATIENT].[SensitiveFlag] AS [SPATIENT_SensitiveFlag] ,[CRS].[SPATIENT].[Sta3n] AS [SPATIENT_Sta3n] ,[CRS].[SPATIENT].[State] AS [SPATIENT_State] ,[CRS].[SPATIENT].[StateIEN] AS [SPATIENT_StateIEN] ,[CRS].[SPATIENT].[StateSID] AS [SPATIENT_StateSID] ,[CRS].[SPATIENT].[STD_COMBATLOCATION_ID] AS [SPATIENT_STD_COMBATLOCATION_ID] ,[CRS].[SPATIENT].[STD_ENTHNICITY_ID] AS [SPATIENT_STD_ENTHNICITY_ID] ,[CRS].[SPATIENT].[STD_GENDER_ID] AS [SPATIENT_STD_GENDER_ID] ,[CRS].[SPATIENT].[STD_MARITALSTATUS_ID] AS [SPATIENT_STD_MARITALSTATUS_ID] ,[CRS].[SPATIENT].[STD_RACE_ID] AS [SPATIENT_STD_RACE_ID] ,[CRS].[SPATIENT].[STD_SERVICEBRANCH_ID] AS [SPATIENT_STD_SERVICEBRANCH_ID] ,[CRS].[SPATIENT].[StdRegistryId] AS [SPATIENT_StdRegistryId] ,[CRS].[SPATIENT].[StreetAddress1] AS [SPATIENT_StreetAddress1] ,[CRS].[SPATIENT].[StreetAddress2] AS [SPATIENT_StreetAddress2] ,[CRS].[SPATIENT].[StreetAddress3] AS [SPATIENT_StreetAddress3] ,[CRS].[SPATIENT].[TemporaryAddressChangeInstitutionIEN] AS [SPATIENT_TemporaryAddressChangeInstitutionIEN] ,[CRS].[SPATIENT].[Updatedate] AS [SPATIENT_Updatedate] ,[CRS].[SPATIENT].[UpdatedBy] AS [SPATIENT_UpdatedBy] ,[CRS].[SPATIENT].[VeteranFlag] AS [SPATIENT_VeteranFlag] ,[CRS].[SPATIENT].[VistaCreateDate] AS [SPATIENT_VistaCreateDate] ,[CRS].[SPATIENT].[VistaEditDate] AS [SPATIENT_VistaEditDate] ,[CRS].[SPATIENT].[Zip] AS [SPATIENT_Zip] ,[CRS].[SPATIENT].[Zip4] AS [SPATIENT_Zip4] ,[CRS].[STD_REFERRALSTS].[CODE] AS [STD_REFERRALSTS_CODE] ,[CRS].[STD_REFERRALSTS].[CREATED] AS [STD_REFERRALSTS_CREATED] ,[CRS].[STD_REFERRALSTS].[CREATEDBY] AS [STD_REFERRALSTS_CREATEDBY] ,[CRS].[STD_REFERRALSTS].[DESCRIPTION_TEXT] AS [STD_REFERRALSTS_DESCRIPTION_TEXT] ,[CRS].[STD_REFERRALSTS].[ID] AS [STD_REFERRALSTS_ID] ,[CRS].[STD_REFERRALSTS].[INACTIVE_DATE] AS [STD_REFERRALSTS_INACTIVE_DATE] ,[CRS].[STD_REFERRALSTS].[INACTIVE_FLAG] AS [STD_REFERRALSTS_INACTIVE_FLAG] ,[CRS].[STD_REFERRALSTS].[NAME] AS [STD_REFERRALSTS_NAME] ,[CRS].[STD_REFERRALSTS].[SORT_ORDER] AS [STD_REFERRALSTS_SORT_ORDER] ,[CRS].[STD_REFERRALSTS].[STD_REGISTRY_ID] AS [STD_REFERRALSTS_STD_REGISTRY_ID] ,[CRS].[STD_REFERRALSTS].[UPDATED] AS [STD_REFERRALSTS_UPDATED] ,[CRS].[STD_REFERRALSTS].[UPDATEDBY] AS [STD_REFERRALSTS_UPDATEDBY] ,[CRS].[SStaff_SStaff].[City] AS [SStaff_SStaff_City] ,[CRS].[SStaff_SStaff].[CommercialPhone] AS [SStaff_SStaff_CommercialPhone] ,[CRS].[SStaff_SStaff].[CreatedByStaffSID] AS [SStaff_SStaff_CreatedByStaffSID] ,[CRS].[SStaff_SStaff].[DEA] AS [SStaff_SStaff_DEA] ,[CRS].[SStaff_SStaff].[Degree] AS [SStaff_SStaff_Degree] ,[CRS].[SStaff_SStaff].[DelegateOfStaffIEN] AS [SStaff_SStaff_DelegateOfStaffIEN] ,[CRS].[SStaff_SStaff].[DelegateOfStaffSID] AS [SStaff_SStaff_DelegateOfStaffSID] ,[CRS].[SStaff_SStaff].[DelegationDate] AS [SStaff_SStaff_DelegationDate] ,[CRS].[SStaff_SStaff].[DelegationLevel] AS [SStaff_SStaff_DelegationLevel] ,[CRS].[SStaff_SStaff].[DigitalPager] AS [SStaff_SStaff_DigitalPager] ,[CRS].[SStaff_SStaff].[ElectronicSignatureCodeFlag] AS [SStaff_SStaff_ElectronicSignatureCodeFlag] ,[CRS].[SStaff_SStaff].[EmailAddress] AS [SStaff_SStaff_EmailAddress] ,[CRS].[SStaff_SStaff].[EnteredDate] AS [SStaff_SStaff_EnteredDate] ,[CRS].[SStaff_SStaff].[ETLBatchID] AS [SStaff_SStaff_ETLBatchID] ,[CRS].[SStaff_SStaff].[FaxNumber] AS [SStaff_SStaff_FaxNumber] ,[CRS].[SStaff_SStaff].[FirstName] AS [SStaff_SStaff_FirstName] ,[CRS].[SStaff_SStaff].[Gender] AS [SStaff_SStaff_Gender] ,[CRS].[SStaff_SStaff].[HINQEmployeeNumberFlag] AS [SStaff_SStaff_HINQEmployeeNumberFlag] ,[CRS].[SStaff_SStaff].[HomePhone] AS [SStaff_SStaff_HomePhone] ,[CRS].[SStaff_SStaff].[InactivationDate] AS [SStaff_SStaff_InactivationDate] ,[CRS].[SStaff_SStaff].[LastEditedDateTime] AS [SStaff_SStaff_LastEditedDateTime] ,[CRS].[SStaff_SStaff].[LastName] AS [SStaff_SStaff_LastName] ,[CRS].[SStaff_SStaff].[LastSignonDateTime] AS [SStaff_SStaff_LastSignonDateTime] ,[CRS].[SStaff_SStaff].[LastUsedTerminalType] AS [SStaff_SStaff_LastUsedTerminalType] ,[CRS].[SStaff_SStaff].[MailCode] AS [SStaff_SStaff_MailCode] ,[CRS].[SStaff_SStaff].[MiddleName] AS [SStaff_SStaff_MiddleName] ,[CRS].[SStaff_SStaff].[NetworkUsername] AS [SStaff_SStaff_NetworkUsername] ,[CRS].[SStaff_SStaff].[NPI] AS [SStaff_SStaff_NPI] ,[CRS].[SStaff_SStaff].[NPIAuthorizedReleaseFlag] AS [SStaff_SStaff_NPIAuthorizedReleaseFlag] ,[CRS].[SStaff_SStaff].[OfficePhone] AS [SStaff_SStaff_OfficePhone] ,[CRS].[SStaff_SStaff].[OpCode] AS [SStaff_SStaff_OpCode] ,[CRS].[SStaff_SStaff].[PACFlag] AS [SStaff_SStaff_PACFlag] ,[CRS].[SStaff_SStaff].[Phone3] AS [SStaff_SStaff_Phone3] ,[CRS].[SStaff_SStaff].[Phone4] AS [SStaff_SStaff_Phone4] ,[CRS].[SStaff_SStaff].[PositionTitle] AS [SStaff_SStaff_PositionTitle] ,[CRS].[SStaff_SStaff].[Provider_ID] AS [SStaff_SStaff_Provider_ID] ,[CRS].[SStaff_SStaff].[ProviderClass] AS [SStaff_SStaff_ProviderClass] ,[CRS].[SStaff_SStaff].[ProviderClassSID] AS [SStaff_SStaff_ProviderClassSID] ,[CRS].[SStaff_SStaff].[ProviderScheduleType] AS [SStaff_SStaff_ProviderScheduleType] ,[CRS].[SStaff_SStaff].[Room] AS [SStaff_SStaff_Room] ,[CRS].[SStaff_SStaff].[ServiceComputationDate] AS [SStaff_SStaff_ServiceComputationDate] ,[CRS].[SStaff_SStaff].[ServiceSection] AS [SStaff_SStaff_ServiceSection] ,[CRS].[SStaff_SStaff].[ServiceSectionSID] AS [SStaff_SStaff_ServiceSectionSID] ,[CRS].[SStaff_SStaff].[ServiceType] AS [SStaff_SStaff_ServiceType] ,[CRS].[SStaff_SStaff].[SignatureBlockName] AS [SStaff_SStaff_SignatureBlockName] ,[CRS].[SStaff_SStaff].[SignatureBlockTitle] AS [SStaff_SStaff_SignatureBlockTitle] ,[CRS].[SStaff_SStaff].[SocialWorkerImmediateSupervisorStaffSID] AS [SStaff_SStaff_SocialWorkerImmediateSupervisorStaffSID] ,[CRS].[SStaff_SStaff].[SocialWorkerPositionTitle] AS [SStaff_SStaff_SocialWorkerPositionTitle] ,[CRS].[SStaff_SStaff].[Sta3n] AS [SStaff_SStaff_Sta3n] ,[CRS].[SStaff_SStaff].[StaffIEN] AS [SStaff_SStaff_StaffIEN] ,[CRS].[SStaff_SStaff].[StaffName] AS [SStaff_SStaff_StaffName] ,[CRS].[SStaff_SStaff].[StaffNamePrefix] AS [SStaff_SStaff_StaffNamePrefix] ,[CRS].[SStaff_SStaff].[StaffNameSuffix] AS [SStaff_SStaff_StaffNameSuffix] ,[CRS].[SStaff_SStaff].[StaffSID] AS [SStaff_SStaff_StaffSID] ,[CRS].[SStaff_SStaff].[StateName] AS [SStaff_SStaff_StateName] ,[CRS].[SStaff_SStaff].[StreetAddress1] AS [SStaff_SStaff_StreetAddress1] ,[CRS].[SStaff_SStaff].[StreetAddress2] AS [SStaff_SStaff_StreetAddress2] ,[CRS].[SStaff_SStaff].[StreetAddress3] AS [SStaff_SStaff_StreetAddress3] ,[CRS].[SStaff_SStaff].[SupplyEmployee] AS [SStaff_SStaff_SupplyEmployee] ,[CRS].[SStaff_SStaff].[TemporaryAddress1] AS [SStaff_SStaff_TemporaryAddress1] ,[CRS].[SStaff_SStaff].[TemporaryAddress2] AS [SStaff_SStaff_TemporaryAddress2] ,[CRS].[SStaff_SStaff].[TemporaryAddress3] AS [SStaff_SStaff_TemporaryAddress3] ,[CRS].[SStaff_SStaff].[TemporaryAddressEndDate] AS [SStaff_SStaff_TemporaryAddressEndDate] ,[CRS].[SStaff_SStaff].[TemporaryAddressStartDate] AS [SStaff_SStaff_TemporaryAddressStartDate] ,[CRS].[SStaff_SStaff].[TemporaryCity] AS [SStaff_SStaff_TemporaryCity] ,[CRS].[SStaff_SStaff].[TemporaryStateName] AS [SStaff_SStaff_TemporaryStateName] ,[CRS].[SStaff_SStaff].[TemporaryZipCode] AS [SStaff_SStaff_TemporaryZipCode] ,[CRS].[SStaff_SStaff].[TerminationDate] AS [SStaff_SStaff_TerminationDate] ,[CRS].[SStaff_SStaff].[TerminationReason] AS [SStaff_SStaff_TerminationReason] ,[CRS].[SStaff_SStaff].[VANumber] AS [SStaff_SStaff_VANumber] ,[CRS].[SStaff_SStaff].[VerifyCodeLastChangedDate] AS [SStaff_SStaff_VerifyCodeLastChangedDate] ,[CRS].[SStaff_SStaff].[VistaCreateDate] AS [SStaff_SStaff_VistaCreateDate] ,[CRS].[SStaff_SStaff].[VistaEditDate] AS [SStaff_SStaff_VistaEditDate] ,[CRS].[SStaff_SStaff].[VoicePager] AS [SStaff_SStaff_VoicePager] ,[CRS].[SStaff_SStaff].[ZipCode] AS [SStaff_SStaff_ZipCode] FROM [CRS].[STD_REGISTRY] INNER JOIN [CRS].[REFERRAL] ON [CRS].[STD_REGISTRY].[ID] = [CRS].[REFERRAL].[STD_REGISTRY_ID] INNER JOIN [CRS].[PATIENT] ON [CRS].[REFERRAL].[PATIENT_ID] = [CRS].[PATIENT].[PATIENT_ID] INNER JOIN [CRS].[SPATIENT] ON [CRS].[PATIENT].[PATIENT_ID] = [CRS].[SPATIENT].[PATIENT_ID] INNER JOIN [CRS].[STD_REFERRALSTS] ON [CRS].[REFERRAL].[STD_REFERRALSTS_ID] = [CRS].[STD_REFERRALSTS].[ID] LEFT OUTER JOIN [CRS].[SStaff_SStaff] ON [CRS].[REFERRAL].[PROVIDER_ID] = [CRS].[SStaff_SStaff].[Provider_ID] WHERE [CRS].[STD_REGISTRY].[ID] = {0}";
        private string reportServerUrlField;
        private SharedDataSetDataSet[] dataSetField;

        public SharedDataSet()
        {
            this.xmlns.Add("", "http://schemas.microsoft.com/sqlserver/reporting/2010/01/shareddatasetdefinition");
            this.xmlns.Add("rd", "http://schemas.microsoft.com/SQLServer/reporting/reportdesigner");
        }

        public SharedDataSet(Int32 REGISTRY_ID)
        {
            this.xmlns.Add("", "http://schemas.microsoft.com/sqlserver/reporting/2010/01/shareddatasetdefinition");
            this.xmlns.Add("rd", "http://schemas.microsoft.com/SQLServer/reporting/reportdesigner");

            DAL.DBUtils utils = new DAL.DBUtils();
            this.reportServerUrlField = utils.ReportServerUrl;

            this.dataSetField = new SharedDataSetDataSet[1];
            this.dataSetField[0] = new SharedDataSetDataSet();
            this.dataSetField[0].Name = "DataSet1";

            this.dataSetField[0].Query = new SharedDataSetDataSetQuery[1];
            this.dataSetField[0].Query[0] = new SharedDataSetDataSetQuery();
            this.dataSetField[0].Query[0].DataSourceReference = "/DataSources/RegistryConnectionString";
            this.dataSetField[0].Query[0].CommandText = string.Format(COMMANDTEXT, REGISTRY_ID.ToString());
            this.dataSetField[0].Query[0].UseGenericDesigner = "true";

            SharedDataSetDataSetFieldsField[] fields = null;

            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_CODE", DataField = "STD_REGISTRY_CODE", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_COMMENTS", DataField = "STD_REGISTRY_COMMENTS", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_CREATED", DataField = "STD_REGISTRY_CREATED", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_CREATEDBY", DataField = "STD_REGISTRY_CREATEDBY", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_DESCRIPTION_TEXT", DataField = "STD_REGISTRY_DESCRIPTION_TEXT", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_ID", DataField = "STD_REGISTRY_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_INACTIVE_DATE", DataField = "STD_REGISTRY_INACTIVE_DATE", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_INACTIVE_FLAG", DataField = "STD_REGISTRY_INACTIVE_FLAG", TypeName = "System.Boolean" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_NAME", DataField = "STD_REGISTRY_NAME", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_REGISTRY_ADMINISTRATOR", DataField = "STD_REGISTRY_REGISTRY_ADMINISTRATOR", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_REGISTRY_OWNER", DataField = "STD_REGISTRY_REGISTRY_OWNER", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_REGISTRY_SUPPORT_CONTACT", DataField = "STD_REGISTRY_REGISTRY_SUPPORT_CONTACT", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_SORT_ORDER", DataField = "STD_REGISTRY_SORT_ORDER", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_UPDATED", DataField = "STD_REGISTRY_UPDATED", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REGISTRY_UPDATEDBY", DataField = "STD_REGISTRY_UPDATEDBY", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_COMMENT_TEXT", DataField = "REFERRAL_COMMENT_TEXT", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_ID", DataField = "STD_REFERRALSTS_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_CREATED", DataField = "REFERRAL_CREATED", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_CREATEDBY", DataField = "REFERRAL_CREATEDBY", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_CREATEDSOURCE", DataField = "REFERRAL_CREATEDSOURCE", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_DUPLICATE_FLAG", DataField = "REFERRAL_DUPLICATE_FLAG", TypeName = "System.Boolean" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_PATIENT_ID", DataField = "REFERRAL_PATIENT_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_PROVIDER_ID", DataField = "REFERRAL_PROVIDER_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_REFERRAL_CLASS_TEXT", DataField = "REFERRAL_REFERRAL_CLASS_TEXT", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_REFERRAL_DATE", DataField = "REFERRAL_REFERRAL_DATE", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_REFERRAL_ID", DataField = "REFERRAL_REFERRAL_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_REVIEW_BY", DataField = "REFERRAL_REVIEW_BY", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_REVIEW_DATE", DataField = "REFERRAL_REVIEW_DATE", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_STD_REFERRALSTS_ID", DataField = "REFERRAL_STD_REFERRALSTS_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_STD_REGISTRY_ID", DataField = "REFERRAL_STD_REGISTRY_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_STD_REMINDERCLASS_ID", DataField = "REFERRAL_STD_REMINDERCLASS_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_UPDATED", DataField = "REFERRAL_UPDATED", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_UPDATEDBY", DataField = "REFERRAL_UPDATEDBY", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "REFERRAL_UPDATEDSOURCE", DataField = "REFERRAL_UPDATEDSOURCE", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_BIRTH_DATE", DataField = "PATIENT_BIRTH_DATE", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_CELL_PHONE", DataField = "PATIENT_CELL_PHONE", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_CREATED", DataField = "PATIENT_CREATED", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_CREATEDBY", DataField = "PATIENT_CREATEDBY", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_DEATH_DATE", DataField = "PATIENT_DEATH_DATE", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_EMAIL_ADDRESS", DataField = "PATIENT_EMAIL_ADDRESS", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_FIRST_NAME", DataField = "PATIENT_FIRST_NAME", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_LAST_NAME", DataField = "PATIENT_LAST_NAME", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_MIDDLE_NAME", DataField = "PATIENT_MIDDLE_NAME", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_OEFOIF_IND", DataField = "PATIENT_OEFOIF_IND", TypeName = "System.Boolean" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_PATIENT_ID", DataField = "PATIENT_PATIENT_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_PATIENTSID", DataField = "PATIENT_PATIENTSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_PERFERRED_ADDRESS_TYPE", DataField = "PATIENT_PERFERRED_ADDRESS_TYPE", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_UPDATED", DataField = "PATIENT_UPDATED", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "PATIENT_UPDATEDBY", DataField = "PATIENT_UPDATEDBY", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_AddressChangeInstitutionIEN", DataField = "SPATIENT_AddressChangeInstitutionIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_AddressChangeInstitutionSID", DataField = "SPATIENT_AddressChangeInstitutionSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_AddressChangeStaffIEN", DataField = "SPATIENT_AddressChangeStaffIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_AddressChangeStaffSID", DataField = "SPATIENT_AddressChangeStaffSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Age", DataField = "SPATIENT_Age", TypeName = "System.Decimal" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_BadAddressIndicator", DataField = "SPATIENT_BadAddressIndicator", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_CDDeterminingInstitutionIEN", DataField = "SPATIENT_CDDeterminingInstitutionIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_City", DataField = "SPATIENT_City", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_CombatFromVistaDate", DataField = "SPATIENT_CombatFromVistaDate", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_CombatToVistaDate", DataField = "SPATIENT_CombatToVistaDate", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_ConfidentialAddressActiveFlag", DataField = "SPATIENT_ConfidentialAddressActiveFlag", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Country", DataField = "SPATIENT_Country", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_CountryIEN", DataField = "SPATIENT_CountryIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_CountrySID", DataField = "SPATIENT_CountrySID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_County", DataField = "SPATIENT_County", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Created", DataField = "SPATIENT_Created", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_CreatedBy", DataField = "SPATIENT_CreatedBy", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_CurrentMeansTestStatusIEN", DataField = "SPATIENT_CurrentMeansTestStatusIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_DateOfBirth", DataField = "SPATIENT_DateOfBirth", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_DateOfBirthText", DataField = "SPATIENT_DateOfBirthText", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_DateOfDeath", DataField = "SPATIENT_DateOfDeath", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_DateOfDeathText", DataField = "SPATIENT_DateOfDeathText", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Deceased", DataField = "SPATIENT_Deceased", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_DEFAULT_RECORD", DataField = "SPATIENT_DEFAULT_RECORD", TypeName = "System.Boolean" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Eligibility", DataField = "SPATIENT_Eligibility", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_EligibilityIEN", DataField = "SPATIENT_EligibilityIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_EligibilitySID", DataField = "SPATIENT_EligibilitySID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_EligibilityStatus", DataField = "SPATIENT_EligibilityStatus", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_EligibilityVACode", DataField = "SPATIENT_EligibilityVACode", TypeName = "System.Decimal" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_EligibilityVerificationSource", DataField = "SPATIENT_EligibilityVerificationSource", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_EmailAddress", DataField = "SPATIENT_EmailAddress", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_EnteredIntoFileDate", DataField = "SPATIENT_EnteredIntoFileDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_EnteredIntoFileDateTransformSID", DataField = "SPATIENT_EnteredIntoFileDateTransformSID", TypeName = "System.Int64" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_EnteredIntoFileVistaErrorDate", DataField = "SPATIENT_EnteredIntoFileVistaErrorDate", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_ETLBatchID", DataField = "SPATIENT_ETLBatchID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_ExcludeFromFacilityDirectoryFlag", DataField = "SPATIENT_ExcludeFromFacilityDirectoryFlag", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Gender", DataField = "SPATIENT_Gender", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISAddressType", DataField = "SPATIENT_GISAddressType", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISAddressUpdatedDate", DataField = "SPATIENT_GISAddressUpdatedDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISCongressDistrict", DataField = "SPATIENT_GISCongressDistrict", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISFIPSCode", DataField = "SPATIENT_GISFIPSCode", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISLocatorName", DataField = "SPATIENT_GISLocatorName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISMarket", DataField = "SPATIENT_GISMarket", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISMatchedAddress", DataField = "SPATIENT_GISMatchedAddress", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISMatchMethodCode", DataField = "SPATIENT_GISMatchMethodCode", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISMatchScore", DataField = "SPATIENT_GISMatchScore", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISMatchStatusCode", DataField = "SPATIENT_GISMatchStatusCode", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISPatientAddressLatitude", DataField = "SPATIENT_GISPatientAddressLatitude", TypeName = "System.Double" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISPatientAddressLongitude", DataField = "SPATIENT_GISPatientAddressLongitude", TypeName = "System.Double" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISSector", DataField = "SPATIENT_GISSector", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISStreetSide", DataField = "SPATIENT_GISStreetSide", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISSubmarket", DataField = "SPATIENT_GISSubmarket", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_GISURH", DataField = "SPATIENT_GISURH", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_InsuranceCoverageFlag", DataField = "SPATIENT_InsuranceCoverageFlag", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_LastServiceEntryDate", DataField = "SPATIENT_LastServiceEntryDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_LastServiceEntryDateTransformSID", DataField = "SPATIENT_LastServiceEntryDateTransformSID", TypeName = "System.Int64" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_LastServiceEntryVistaErrorDate", DataField = "SPATIENT_LastServiceEntryVistaErrorDate", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_LastServiceSeparationDate", DataField = "SPATIENT_LastServiceSeparationDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_LastServiceSeparationDateTransformSID", DataField = "SPATIENT_LastServiceSeparationDateTransformSID", TypeName = "System.Int64" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_LastServiceSeparationVistaErrorDate", DataField = "SPATIENT_LastServiceSeparationVistaErrorDate", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_MaritalStatus", DataField = "SPATIENT_MaritalStatus", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_MaritalStatusIEN", DataField = "SPATIENT_MaritalStatusIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_MaritalStatusSID", DataField = "SPATIENT_MaritalStatusSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_MedicaidNumber", DataField = "SPATIENT_MedicaidNumber", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_MothersMaidenName", DataField = "SPATIENT_MothersMaidenName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_OEF_OIF_IND", DataField = "SPATIENT_OEF_OIF_IND", TypeName = "System.Boolean" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_OpCode", DataField = "SPATIENT_OpCode", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Patient_ID", DataField = "SPATIENT_Patient_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PatientFirstName", DataField = "SPATIENT_PatientFirstName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PatientICN", DataField = "SPATIENT_PatientICN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PatientICNChecksum", DataField = "SPATIENT_PatientICNChecksum", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PatientIEN", DataField = "SPATIENT_PatientIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PatientLastName", DataField = "SPATIENT_PatientLastName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PatientName", DataField = "SPATIENT_PatientName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PatientSID", DataField = "SPATIENT_PatientSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PatientSSN", DataField = "SPATIENT_PatientSSN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PercentServiceConnect", DataField = "SPATIENT_PercentServiceConnect", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PeriodOfService", DataField = "SPATIENT_PeriodOfService", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PeriodOfServiceIEN", DataField = "SPATIENT_PeriodOfServiceIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PeriodOfServiceSID", DataField = "SPATIENT_PeriodOfServiceSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PhoneCellular", DataField = "SPATIENT_PhoneCellular", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PhoneResidence", DataField = "SPATIENT_PhoneResidence", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PhoneWork", DataField = "SPATIENT_PhoneWork", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PostalCode", DataField = "SPATIENT_PostalCode", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_POWLocationIEN", DataField = "SPATIENT_POWLocationIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PreferredInstitutionIEN", DataField = "SPATIENT_PreferredInstitutionIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Province", DataField = "SPATIENT_Province", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PseudoSSNFlag", DataField = "SPATIENT_PseudoSSNFlag", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_PurpleHeartInstitutionIEN", DataField = "SPATIENT_PurpleHeartInstitutionIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_RaceIEN", DataField = "SPATIENT_RaceIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_RaceSID", DataField = "SPATIENT_RaceSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Religion", DataField = "SPATIENT_Religion", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_ReligionIEN", DataField = "SPATIENT_ReligionIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_ReligionSID", DataField = "SPATIENT_ReligionSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_RoomBedIEN", DataField = "SPATIENT_RoomBedIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_ScrSSN", DataField = "SPATIENT_ScrSSN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_SensitiveFlag", DataField = "SPATIENT_SensitiveFlag", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Sta3n", DataField = "SPATIENT_Sta3n", TypeName = "System.Int16" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_State", DataField = "SPATIENT_State", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_StateIEN", DataField = "SPATIENT_StateIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_StateSID", DataField = "SPATIENT_StateSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_STD_COMBATLOCATION_ID", DataField = "SPATIENT_STD_COMBATLOCATION_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_STD_ENTHNICITY_ID", DataField = "SPATIENT_STD_ENTHNICITY_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_STD_GENDER_ID", DataField = "SPATIENT_STD_GENDER_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_STD_MARITALSTATUS_ID", DataField = "SPATIENT_STD_MARITALSTATUS_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_STD_RACE_ID", DataField = "SPATIENT_STD_RACE_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_STD_SERVICEBRANCH_ID", DataField = "SPATIENT_STD_SERVICEBRANCH_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_StdRegistryId", DataField = "SPATIENT_StdRegistryId", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_StreetAddress1", DataField = "SPATIENT_StreetAddress1", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_StreetAddress2", DataField = "SPATIENT_StreetAddress2", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_StreetAddress3", DataField = "SPATIENT_StreetAddress3", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_TemporaryAddressChangeInstitutionIEN", DataField = "SPATIENT_TemporaryAddressChangeInstitutionIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Updatedate", DataField = "SPATIENT_Updatedate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_UpdatedBy", DataField = "SPATIENT_UpdatedBy", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_VeteranFlag", DataField = "SPATIENT_VeteranFlag", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_VistaCreateDate", DataField = "SPATIENT_VistaCreateDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_VistaEditDate", DataField = "SPATIENT_VistaEditDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Zip", DataField = "SPATIENT_Zip", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SPATIENT_Zip4", DataField = "SPATIENT_Zip4", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_CODE", DataField = "STD_REFERRALSTS_CODE", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_CREATED", DataField = "STD_REFERRALSTS_CREATED", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_CREATEDBY", DataField = "STD_REFERRALSTS_CREATEDBY", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_DESCRIPTION_TEXT", DataField = "STD_REFERRALSTS_DESCRIPTION_TEXT", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_INACTIVE_DATE", DataField = "STD_REFERRALSTS_INACTIVE_DATE", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_INACTIVE_FLAG", DataField = "STD_REFERRALSTS_INACTIVE_FLAG", TypeName = "System.Boolean" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_NAME", DataField = "STD_REFERRALSTS_NAME", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_SORT_ORDER", DataField = "STD_REFERRALSTS_SORT_ORDER", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_STD_REGISTRY_ID", DataField = "STD_REFERRALSTS_STD_REGISTRY_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_UPDATED", DataField = "STD_REFERRALSTS_UPDATED", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "STD_REFERRALSTS_UPDATEDBY", DataField = "STD_REFERRALSTS_UPDATEDBY", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_City", DataField = "SStaff_SStaff_City", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_CommercialPhone", DataField = "SStaff_SStaff_CommercialPhone", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_CreatedByStaffSID", DataField = "SStaff_SStaff_CreatedByStaffSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_DEA", DataField = "SStaff_SStaff_DEA", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_Degree", DataField = "SStaff_SStaff_Degree", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_DelegateOfStaffIEN", DataField = "SStaff_SStaff_DelegateOfStaffIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_DelegateOfStaffSID", DataField = "SStaff_SStaff_DelegateOfStaffSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_DelegationDate", DataField = "SStaff_SStaff_DelegationDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_DelegationLevel", DataField = "SStaff_SStaff_DelegationLevel", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_DigitalPager", DataField = "SStaff_SStaff_DigitalPager", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_ElectronicSignatureCodeFlag", DataField = "SStaff_SStaff_ElectronicSignatureCodeFlag", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_EmailAddress", DataField = "SStaff_SStaff_EmailAddress", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_EnteredDate", DataField = "SStaff_SStaff_EnteredDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_ETLBatchID", DataField = "SStaff_SStaff_ETLBatchID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_FaxNumber", DataField = "SStaff_SStaff_FaxNumber", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_FirstName", DataField = "SStaff_SStaff_FirstName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_Gender", DataField = "SStaff_SStaff_Gender", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_HINQEmployeeNumberFlag", DataField = "SStaff_SStaff_HINQEmployeeNumberFlag", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_HomePhone", DataField = "SStaff_SStaff_HomePhone", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_InactivationDate", DataField = "SStaff_SStaff_InactivationDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_LastEditedDateTime", DataField = "SStaff_SStaff_LastEditedDateTime", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_LastName", DataField = "SStaff_SStaff_LastName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_LastSignonDateTime", DataField = "SStaff_SStaff_LastSignonDateTime", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_LastUsedTerminalType", DataField = "SStaff_SStaff_LastUsedTerminalType", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_MailCode", DataField = "SStaff_SStaff_MailCode", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_MiddleName", DataField = "SStaff_SStaff_MiddleName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_NetworkUsername", DataField = "SStaff_SStaff_NetworkUsername", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_NPI", DataField = "SStaff_SStaff_NPI", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_NPIAuthorizedReleaseFlag", DataField = "SStaff_SStaff_NPIAuthorizedReleaseFlag", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_OfficePhone", DataField = "SStaff_SStaff_OfficePhone", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_OpCode", DataField = "SStaff_SStaff_OpCode", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_PACFlag", DataField = "SStaff_SStaff_PACFlag", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_Phone3", DataField = "SStaff_SStaff_Phone3", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_Phone4", DataField = "SStaff_SStaff_Phone4", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_PositionTitle", DataField = "SStaff_SStaff_PositionTitle", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_Provider_ID", DataField = "SStaff_SStaff_Provider_ID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_ProviderClass", DataField = "SStaff_SStaff_ProviderClass", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_ProviderClassSID", DataField = "SStaff_SStaff_ProviderClassSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_ProviderScheduleType", DataField = "SStaff_SStaff_ProviderScheduleType", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_Room", DataField = "SStaff_SStaff_Room", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_ServiceComputationDate", DataField = "SStaff_SStaff_ServiceComputationDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_ServiceSection", DataField = "SStaff_SStaff_ServiceSection", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_ServiceSectionSID", DataField = "SStaff_SStaff_ServiceSectionSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_ServiceType", DataField = "SStaff_SStaff_ServiceType", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_SignatureBlockName", DataField = "SStaff_SStaff_SignatureBlockName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_SignatureBlockTitle", DataField = "SStaff_SStaff_SignatureBlockTitle", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_SocialWorkerImmediateSupervisorStaffSID", DataField = "SStaff_SStaff_SocialWorkerImmediateSupervisorStaffSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_SocialWorkerPositionTitle", DataField = "SStaff_SStaff_SocialWorkerPositionTitle", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_Sta3n", DataField = "SStaff_SStaff_Sta3n", TypeName = "System.Int16" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_StaffIEN", DataField = "SStaff_SStaff_StaffIEN", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_StaffName", DataField = "SStaff_SStaff_StaffName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_StaffNamePrefix", DataField = "SStaff_SStaff_StaffNamePrefix", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_StaffNameSuffix", DataField = "SStaff_SStaff_StaffNameSuffix", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_StaffSID", DataField = "SStaff_SStaff_StaffSID", TypeName = "System.Int32" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_StateName", DataField = "SStaff_SStaff_StateName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_StreetAddress1", DataField = "SStaff_SStaff_StreetAddress1", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_StreetAddress2", DataField = "SStaff_SStaff_StreetAddress2", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_StreetAddress3", DataField = "SStaff_SStaff_StreetAddress3", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_SupplyEmployee", DataField = "SStaff_SStaff_SupplyEmployee", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_TemporaryAddress1", DataField = "SStaff_SStaff_TemporaryAddress1", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_TemporaryAddress2", DataField = "SStaff_SStaff_TemporaryAddress2", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_TemporaryAddress3", DataField = "SStaff_SStaff_TemporaryAddress3", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_TemporaryAddressEndDate", DataField = "SStaff_SStaff_TemporaryAddressEndDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_TemporaryAddressStartDate", DataField = "SStaff_SStaff_TemporaryAddressStartDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_TemporaryCity", DataField = "SStaff_SStaff_TemporaryCity", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_TemporaryStateName", DataField = "SStaff_SStaff_TemporaryStateName", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_TemporaryZipCode", DataField = "SStaff_SStaff_TemporaryZipCode", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_TerminationDate", DataField = "SStaff_SStaff_TerminationDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_TerminationReason", DataField = "SStaff_SStaff_TerminationReason", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_VANumber", DataField = "SStaff_SStaff_VANumber", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_VerifyCodeLastChangedDate", DataField = "SStaff_SStaff_VerifyCodeLastChangedDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_VistaCreateDate", DataField = "SStaff_SStaff_VistaCreateDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_VistaEditDate", DataField = "SStaff_SStaff_VistaEditDate", TypeName = "System.DateTime" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_VoicePager", DataField = "SStaff_SStaff_VoicePager", TypeName = "System.String" });
            utils.AddToArray(ref fields, new SharedDataSetDataSetFieldsField() { Name = "SStaff_SStaff_ZipCode", DataField = "SStaff_SStaff_ZipCode", TypeName = "System.String" });

            this.dataSetField[0].Fields = fields;
        }

        [System.Xml.Serialization.XmlNamespaceDeclarations]
        public System.Xml.Serialization.XmlSerializerNamespaces xmlns = new System.Xml.Serialization.XmlSerializerNamespaces();

        [System.Xml.Serialization.XmlElementAttribute(Namespace = "http://schemas.microsoft.com/SQLServer/reporting/reportdesigner")]
        public string ReportServerUrl
        {
            get
            {
                return this.reportServerUrlField;
            }
            set
            {
                this.reportServerUrlField = value;
            }
        }

        [System.Xml.Serialization.XmlElementAttribute("DataSet")]
        public SharedDataSetDataSet[] DataSet
        {
            get
            {
                return this.dataSetField;
            }
            set
            {
                this.dataSetField = value;
            }
        }
    }
}
